package com.bitbof.escape.entities;

import java.util.ArrayList;
import java.util.List;

import org.lwjgl.examples.spaceinvaders.Texture;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector2f;

import com.bitbof.escape.Art;
import com.bitbof.escape.Sound;

/*
 * take care of the whole elastic band....
 * what if the level is really big? it won't be. ...or by creating
 * these separate worlds you create separate bands. the band gets fixated the moment
 * you leave the world. and when you get thrown back into it you get pulled again.
 * 
 * where to handle the collision with elastic hooks?
 * inside here...or using the world.
 * elasticBand should have a reference to world....then access all hooks
 */
public class ElasticBand implements Entity {
	public int maxLength = 1000;
	public World world;
	public Player player;
	public Vector2f pos; // base
	public boolean alive = true;
	public float strength = 0.005f;
	public float radius = 10;
	public Vector2f force = new Vector2f(0, 0);
	public int timeoutCounter = 0; //don't get attached if overstretched...for a while;
	
	public List<Hook> segments = new ArrayList<Hook>();
	
	public ElasticBand(World world, Player player, float x, float y) {
		this.world = world;
		pos = new Vector2f(x, y);
		this.player = player;
	}

	@Override
	public void tick() {
		if (!alive)
			return;
		
		for(int i = 0; i < segments.size(); i++){
			Hook h = segments.get(i);
			if(h.getAttachedBand() != this) {
				segments.remove(i--);
			}
		}
		
		Vector2f last = new Vector2f(pos);
		if(segments.size() >= 1)
			last = segments.get(segments.size() - 1).getPos();
		List<Hook> hooks = new ArrayList<Hook>();
		hooks.addAll(world.hooks);
		//still need to check for the health of hook
		float lastLength = new Vector2f(player.pos.x-last.x, player.pos.y-last.y).length();
		//can't hook if too long
		timeoutCounter--;
		if(lastLength < maxLength && timeoutCounter <= 0) {
			for (Hook h : hooks) {
				if(h.getAttachedBand() != null)
					continue;
				Vector2f hpos = h.getPos();
				float distance = pointToLineDistance(new Vector2f(last), new Vector2f(player.pos), new Vector2f(hpos));
				if (distance < radius+h.getRadius()) {
					h.attachBand(this);
					if(h.getRadius() == 10) {
						Sound.play(Sound.HOOK);
					} else if(h.getRadius() == 40) {
						Sound.hookMedium.play();
					} else if(h.getRadius() == 80) {
						Sound.hookLarge.play();
					} else {
						Sound.play(Sound.HOOK_TINY);
					}
					segments.add(h);
					last = new Vector2f(hpos);
					break;
				}
			}
		} if(lastLength >= maxLength) {
			timeoutCounter = 100;
		}

		Vector2f rel = new Vector2f(player.pos.x - last.x, player.pos.y
				- last.y);
		force.x = -rel.x * strength;
		force.y = -rel.y * strength;
		//

	}

	@Override
	public void render() {
		if (!alive)
			return;
		
		Vector2f last = new Vector2f(pos);
		{ // segments
			for(Hook h: segments) {
				renderSegment(h.getPos(), new Vector2f(last));
				last = h.getPos();
			}
		}
		{ // last segment attached to player
			renderSegment(new Vector2f(last), new Vector2f(player.pos));
		}
		
		{ // elastic base
			Texture texture = Art.ball;
			texture.bind();
			GL11.glPushMatrix();
			GL11.glColor4f(0, 0, 0, 1);
			GL11.glTranslatef(pos.x, pos.y, 0);
			GL11.glRotatef(1, 0, 0, 0);

			GL11.glScalef(radius * 10, radius * 10, 0);

			GL11.glBegin(GL11.GL_QUADS);
			GL11.glTexCoord2f(0, 0);
			GL11.glVertex2f(-0.5f, -0.5f);
			GL11.glTexCoord2f(0, texture.getHeight());
			GL11.glVertex2f(0.5f, -0.5f);
			GL11.glTexCoord2f(texture.getWidth(), texture.getHeight());
			GL11.glVertex2f(0.5f, 0.5f);
			GL11.glTexCoord2f(texture.getWidth(), 0);
			GL11.glVertex2f(-0.5f, 0.5f);
			GL11.glEnd();

			GL11.glPopMatrix();
		}
		/*ElasticSegment last = segments.get(segments.size() - 1);
		last.pos2.x = player.pos.x;
		last.pos2.y = player.pos.y;
		for (ElasticSegment es : segments)
			es.render();*/
	}
	
	public void renderSegment(Vector2f pos, Vector2f pos2) {
		Texture texture = Art.band;
		texture.bind();
		GL11.glPushMatrix();
		GL11.glColor4f(1, 1,1, 1);
		if(timeoutCounter > 0)
			GL11.glColor4f(1,1,1,0.3f);
		GL11.glTranslatef(pos.x, pos.y, 0);
		
		Vector2f rel = new Vector2f(pos2.x-pos.x, pos2.y-pos.y);
		
		double angle = Vector2f.angle(rel, new Vector2f(1,0))/Math.PI*180;
		if(rel.y < 0)
			angle *= -1;
		GL11.glRotatef((float) angle, 0, 0, 1);//);
		
		GL11.glTranslatef((new Vector2f(pos2.x-pos.x, pos2.y-pos.y).length())*0.5f, 0, 0);
		GL11.glScalef(new Vector2f(pos2.x-pos.x, pos2.y-pos.y).length(), 20*0.5f, 0);
		GL11.glBegin(GL11.GL_QUADS);
		GL11.glTexCoord2f(0, 0);
		GL11.glVertex2f(-0.5f, -0.5f);
		GL11.glTexCoord2f(0, texture.getHeight());
		GL11.glVertex2f(0.5f, -0.5f);
		GL11.glTexCoord2f(texture.getWidth(), texture.getHeight());
		GL11.glVertex2f(0.5f, 0.5f);
		GL11.glTexCoord2f(texture.getWidth(), 0);
		GL11.glVertex2f(-0.5f, 0.5f);
		GL11.glEnd();

		GL11.glPopMatrix();
	}

	@Override
	public boolean isAlive() {
		return alive;
	}

	public float pointToLineDistance(Vector2f l1, Vector2f l2, Vector2f p) {
			float xDelta = l2.x - l1.x;
			float yDelta = l2.y - l1.y;
			if ((xDelta == 0) && (yDelta == 0)) {
				l2.x += 1;
				l2.y += 1;
				xDelta = 1;
				yDelta = 1;
			}
			float u = ((p.x - l1.x) * xDelta + (p.y - l1.y) * yDelta) / (xDelta * xDelta + yDelta * yDelta);
			Vector2f closestPoint;
			if (u <0) {
				closestPoint = new Vector2f(l1.x, l1.y);
			} else if (u> 1) {
				closestPoint = new Vector2f(l2.x, l2.y);
			} else {
				closestPoint = new Vector2f(l1.x + u * xDelta, l1.y + u * yDelta);
			}
			p.x -= closestPoint.x;
			p.y -= closestPoint.y;
			return Math.abs(p.length());//.distance(closestPoint, new Point(p3.x, p3.y));
		}
}
